<?php

class LogDigitec
{
	private $message;
	private $method;
		
	function verifyMethod($method,$route){	
		switch ($method) {
		case 'GET':
			return self::doGet($route);
			break;
		case 'POST':			
			return self::doPost();
			break;
		case 'PUT':
			return self::doPut($route); 
			break;
		case 'DELETE':
			return self::doDelete($route); 
			break;		
		default:
			http_response_code(405);
			return array('status' => 405, 'message' => 'Méthode non supportée');
      		break;
		}
	}

	function doGet($route){
		http_response_code(400);
		return $arr_json = array('status' => 400, 'message' => 'Hé  Non');
	}
	
	function doPost(){
		$result = 0;
		$message = '';
		$bearerToken = self::getBearerToken();
		
		if ($bearerToken != 'F05B2014AB0E4FBBB62D8B52FD8708D7A6DA5382A4B3B443CE926A66F903CE1E')	{
			$result = 2;
		}
		else {
			try {
					$body = json_decode(file_get_contents('php://input'));
					if (isset($body->message) && isset($body->app)) {
						$app = $body->app;
						$message = $body->message;						
						error_log($app.";".$message, 0);
					}
				} catch (Error $e) {
					$result = 1;
					$message = $e->getMessage();
				}	
		}	
			
		switch ($result) {
		case 0:
			http_response_code(200);
			return $arr_json = array('status' => 200, '$message' => $message);
			break;
		case 1:			
			http_response_code(400);
			return $arr_json = array('status' => 400, 'message' => $message);
			break;	
		case 2:			
			http_response_code(400);
			return $arr_json = array('status' => 400, 'message' => 'Token non valide');
			break;
		default:
			http_response_code(405);
			return array('status' => 405, 'message' => 'Hé Non');
      		break;
		}		
	}
	
	function doPut($route){
		http_response_code(400);
		return $arr_json = array('status' => 400, 'message' => 'Hé Non');
	}
	
	function doDelete($route){
		http_response_code(400);
		return $arr_json = array('status' => 400, 'message' => 'Hé Non');
	}
	
	function getAuthorizationHeader(){
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
        }
        else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
        }
        return $headers;
    }

	function getBearerToken() {
		$headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
				return $matches[1];
			}
		}
		return null;
	}
}
?>